/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.sctp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.spi.SelectorProvider;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.red5.io.sctp.Association;
import org.red5.io.sctp.IAssociationControl;
import org.red5.io.sctp.IServerChannelControl;
import org.red5.io.sctp.SctpChannel;
import org.red5.io.sctp.SctpException;
import org.red5.io.sctp.SctpServerChannel;
import org.red5.io.sctp.SctpSocketOption;
import org.red5.io.sctp.packet.SctpPacket;

public class SctpServerChanneOverUDP
extends SctpServerChannel
implements IServerChannelControl {
    private static final Logger logger = Logger.getLogger("global");
    private static final String MAC_ALGORITHM_NAME = "HmacSHA256";
    private static final int BUFFER_SIZE = 2048;
    private byte[] buffer = new byte[2048];
    private DatagramSocket serverSocket;
    private HashMap<InetSocketAddress, Association> pendingAssociations;
    private int maxNumberOfPendingChannels;
    private Random random = new Random();
    private final Mac messageAuthenticationCode;

    protected SctpServerChanneOverUDP(SelectorProvider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        super(provider);
        SecretKeySpec secretKey = new SecretKeySpec(UUID.randomUUID().toString().getBytes(), MAC_ALGORITHM_NAME);
        this.messageAuthenticationCode = Mac.getInstance(MAC_ALGORITHM_NAME);
        this.messageAuthenticationCode.init(secretKey);
    }

    @Override
    public SctpChannel accept() throws IOException, SctpException, InvalidKeyException, NoSuchAlgorithmException {
        Association association;
        logger.setLevel(Level.INFO);
        DatagramPacket receivePacket = new DatagramPacket(this.buffer, this.buffer.length);
        SctpPacket packet = null;
        while (true) {
            this.serverSocket.receive(receivePacket);
            try {
                packet = new SctpPacket(this.buffer, 0, receivePacket.getLength());
            }
            catch (SctpException e) {
                logger.log(Level.WARNING, e.getMessage());
                continue;
            }
            logger.log(Level.INFO, "receive new packet");
            InetSocketAddress address = new InetSocketAddress(receivePacket.getAddress(), receivePacket.getPort());
            packet.apply(address, this);
            association = this.pendingAssociations.get(address);
            if (association != null && association.getState() == IAssociationControl.State.ESTABLISHED) break;
        }
        return new SctpChannel(association);
    }

    @Override
    public SctpServerChannel bind(SocketAddress local, int backlog) throws IOException {
        this.maxNumberOfPendingChannels = backlog + 1;
        this.pendingAssociations = new HashMap();
        if (this.serverSocket != null) {
            throw new IOException("already bound");
        }
        this.serverSocket = new DatagramSocket(local);
        return this;
    }

    @Override
    public Mac getMac() {
        return this.messageAuthenticationCode;
    }

    @Override
    public boolean addPendingChannel(InetSocketAddress address, int initialTSN, int verificationTag) throws SocketException {
        if (this.pendingAssociations.size() < this.maxNumberOfPendingChannels) {
            Association channel = new Association(this.random, address, initialTSN, verificationTag);
            this.pendingAssociations.put(address, channel);
            return true;
        }
        return false;
    }

    @Override
    public IAssociationControl getPendingChannel(InetSocketAddress address) {
        return this.pendingAssociations.get(address);
    }

    @Override
    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    @Override
    public void send(SctpPacket packet, InetSocketAddress address) throws IOException {
        byte[] data = packet.getBytes();
        this.serverSocket.send(new DatagramPacket(data, data.length, address));
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    @Override
    public void removePendingChannel(InetSocketAddress address) {
    }

    @Override
    public SctpServerChannel bindAddress(InetAddress address) throws IOException {
        return null;
    }

    @Override
    public Set<SocketAddress> getAllLocalAddresses() throws IOException {
        return null;
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
    }

    @Override
    public SctpServerChannel unbindAddress(InetAddress address) throws IOException {
        return null;
    }

    @Override
    public <T> SctpServerChannel setOption(SctpSocketOption<T> name, T value) throws IOException {
        return null;
    }

    @Override
    public Set<SctpSocketOption<?>> supportedOptions() {
        return null;
    }
}

