/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.utils;

import org.apache.mina.core.buffer.IoBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferUtils {
    private static Logger log = LoggerFactory.getLogger(BufferUtils.class);

    public static void writeMediumInt(IoBuffer out, int value) {
        byte[] bytes = new byte[]{(byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        out.put(bytes);
    }

    public static int readUnsignedMediumInt(IoBuffer in) {
        byte[] bytes = new byte[3];
        in.get(bytes);
        int val = 0;
        val += (bytes[0] & 0xFF) * 256 * 256;
        val += (bytes[1] & 0xFF) * 256;
        return val += bytes[2] & 0xFF;
    }

    public static int readMediumInt(IoBuffer in) {
        byte[] bytes = new byte[3];
        in.get(bytes);
        int val = 0;
        val += bytes[0] * 256 * 256;
        val += bytes[1] * 256;
        if ((val += bytes[2]) < 0) {
            val += 256;
        }
        return val;
    }

    public static final int put(IoBuffer out, IoBuffer in, int numBytesMax) {
        if (log.isTraceEnabled()) {
            log.trace("Put\nin buffer: {}\nout buffer: {}\nmax bytes: {}", new Object[]{out, in, numBytesMax});
        }
        int numBytesRead = 0;
        if (in != null) {
            int limit = Math.min(in.limit(), numBytesMax);
            byte[] inBuf = new byte[limit];
            log.trace("Bulk get size: {}", (Object)limit);
            in.get(inBuf);
            byte[] outBuf = BufferUtils.consumeBytes(inBuf, numBytesMax);
            out.put(outBuf);
            numBytesRead = outBuf.length;
            log.trace("In pos: {}", (Object)in.position());
        }
        log.trace("Bytes put: {}", (Object)numBytesRead);
        return numBytesRead;
    }

    public static final byte[] consumeBytes(byte[] in, int numBytesMax) {
        int limit = Math.min(in.length, numBytesMax);
        byte[] out = new byte[limit];
        System.arraycopy(in, 0, out, 0, limit);
        return out;
    }
}

