/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.utils;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Stax2DomBuilder {
    protected boolean mCfgIgnoreWs = false;
    protected boolean mNsAware = true;
    protected String mLastPrefix = null;
    protected String mLastLocalName = null;
    protected String mLastQName = null;

    public void setIgnoreWhitespace(boolean ignoreWS) {
        this.mCfgIgnoreWs = ignoreWS;
    }

    public Document build(XMLStreamReader r) throws ParserConfigurationException, XMLStreamException {
        return this.build(r, DocumentBuilderFactory.newInstance().newDocumentBuilder());
    }

    public Document build(XMLStreamReader r, DocumentBuilder docbuilder) throws XMLStreamException {
        Document doc = docbuilder.newDocument();
        this.build(r, doc);
        return doc;
    }

    public void build(XMLStreamReader r, Document doc) throws XMLStreamException {
        this.buildTree(r, doc);
    }

    protected void buildTree(XMLStreamReader r, Document doc) throws XMLStreamException {
        this.checkReaderSettings(r);
        Node current = doc;
        block14: while (true) {
            Node child;
            int evtType = r.next();
            switch (evtType) {
                case 12: {
                    child = doc.createCDATASection(r.getText());
                    break;
                }
                case 6: {
                    if (this.mCfgIgnoreWs || current == doc) continue block14;
                }
                case 4: {
                    child = doc.createTextNode(r.getText());
                    break;
                }
                case 5: {
                    child = doc.createComment(r.getText());
                    break;
                }
                case 8: {
                    break block14;
                }
                case 2: {
                    if ((current = current.getParentNode()) != null) continue block14;
                    current = doc;
                    continue block14;
                }
                case 14: 
                case 15: {
                    continue block14;
                }
                case 9: {
                    child = doc.createEntityReference(r.getLocalName());
                    break;
                }
                case 3: {
                    child = doc.createProcessingInstruction(r.getPITarget(), r.getPIData());
                    break;
                }
                case 1: {
                    String elemPrefix;
                    String ln = r.getLocalName();
                    Element newElem = this.mNsAware ? ((elemPrefix = r.getPrefix()) != null && elemPrefix.length() > 0 ? doc.createElementNS(r.getNamespaceURI(), this.getQualified(elemPrefix, ln)) : doc.createElementNS(r.getNamespaceURI(), ln)) : doc.createElement(ln);
                    int len = r.getAttributeCount();
                    for (int i = 0; i < len; ++i) {
                        ln = r.getAttributeLocalName(i);
                        if (this.mNsAware) {
                            String prefix = r.getAttributePrefix(i);
                            if (prefix != null && prefix.length() > 0) {
                                ln = this.getQualified(prefix, ln);
                            }
                            Attr attr = doc.createAttributeNS(r.getAttributeNamespace(i), ln);
                            attr.setValue(r.getAttributeValue(i));
                            newElem.setAttributeNodeNS(attr);
                            continue;
                        }
                        Attr attr = doc.createAttribute(ln);
                        attr.setValue(r.getAttributeValue(i));
                        newElem.setAttributeNode(attr);
                    }
                    current.appendChild(newElem);
                    current = newElem;
                    continue block14;
                }
                case 7: {
                    continue block14;
                }
                case 11: {
                    continue block14;
                }
                default: {
                    throw new XMLStreamException("Unrecognized iterator event type: " + r.getEventType() + "; should not receive such types (broken stream reader?)");
                }
            }
            if (child == null) continue;
            current.appendChild(child);
        }
    }

    protected String getQualified(String prefix, String localName) {
        if (localName.equals(this.mLastLocalName) && prefix.endsWith(this.mLastPrefix)) {
            return this.mLastQName;
        }
        String qn = prefix + ":" + localName;
        this.mLastQName = qn;
        return qn;
    }

    protected void checkReaderSettings(XMLStreamReader r) throws XMLStreamException {
        Object o = r.getProperty("javax.xml.stream.isNamespaceAware");
        this.mNsAware = !(o instanceof Boolean) || (Boolean)o != false;
    }
}

