/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.api.stream.support;

import org.red5.server.api.stream.IPlayItem;
import org.red5.server.messaging.IMessageInput;

public class SimplePlayItem
implements IPlayItem,
Comparable<SimplePlayItem> {
    private long created = System.nanoTime();
    protected final String name;
    protected final long start;
    protected final long length;
    protected IMessageInput msgInput;

    private SimplePlayItem(String name) {
        this.name = name;
        this.start = -2L;
        this.length = -1L;
    }

    private SimplePlayItem(String name, long start, long length) {
        this.name = name;
        this.start = start;
        this.length = length;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public IMessageInput getMessageInput() {
        return this.msgInput;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getStart() {
        return this.start;
    }

    public IMessageInput getMsgInput() {
        return this.msgInput;
    }

    public void setMsgInput(IMessageInput msgInput) {
        this.msgInput = msgInput;
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (int)(this.start ^ this.start >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimplePlayItem other = (SimplePlayItem)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.start == other.start;
    }

    @Override
    public int compareTo(SimplePlayItem that) {
        if (this.created > that.getCreated()) {
            return -1;
        }
        if (this.created < that.getCreated()) {
            return 1;
        }
        return 0;
    }

    public static SimplePlayItem build(String name) {
        SimplePlayItem playItem = new SimplePlayItem(name);
        return playItem;
    }

    public static SimplePlayItem build(String name, long start, long length) {
        SimplePlayItem playItem = new SimplePlayItem(name, start, length);
        return playItem;
    }

    public String toString() {
        return "SimplePlayItem [created=" + this.created + ", name=" + this.name + ", start=" + this.start + ", length=" + this.length + "]";
    }
}

