/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.messaging;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.red5.server.messaging.IConsumer;
import org.red5.server.messaging.IPipe;
import org.red5.server.messaging.IPipeConnectionListener;
import org.red5.server.messaging.IProvider;
import org.red5.server.messaging.OOBControlMessage;
import org.red5.server.messaging.PipeConnectionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public abstract class AbstractPipe
implements IPipe {
    private static final Logger log = LoggerFactory.getLogger(AbstractPipe.class);
    protected volatile CopyOnWriteArrayList<IConsumer> consumers = new CopyOnWriteArrayList();
    protected volatile CopyOnWriteArrayList<IProvider> providers = new CopyOnWriteArrayList();
    protected volatile CopyOnWriteArrayList<IPipeConnectionListener> listeners = new CopyOnWriteArrayList();
    private static ExecutorService taskExecutor;

    @Override
    public boolean subscribe(IConsumer consumer, Map<String, Object> paramMap) {
        boolean success = this.consumers.addIfAbsent(consumer);
        if (success && consumer instanceof IPipeConnectionListener) {
            this.listeners.addIfAbsent((IPipeConnectionListener)((Object)consumer));
        }
        return success;
    }

    @Override
    public boolean subscribe(IProvider provider, Map<String, Object> paramMap) {
        boolean success = this.providers.addIfAbsent(provider);
        if (success && provider instanceof IPipeConnectionListener) {
            this.listeners.addIfAbsent((IPipeConnectionListener)((Object)provider));
        }
        return success;
    }

    @Override
    public boolean unsubscribe(IProvider provider) {
        if (this.providers.remove(provider)) {
            this.fireProviderConnectionEvent(provider, PipeConnectionEvent.EventType.PROVIDER_DISCONNECT, null);
            this.listeners.remove(provider);
            return true;
        }
        return false;
    }

    @Override
    public boolean unsubscribe(IConsumer consumer) {
        if (this.consumers.remove(consumer)) {
            this.fireConsumerConnectionEvent(consumer, PipeConnectionEvent.EventType.CONSUMER_DISCONNECT, null);
            this.listeners.remove(consumer);
            return true;
        }
        return false;
    }

    @Override
    public void addPipeConnectionListener(IPipeConnectionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removePipeConnectionListener(IPipeConnectionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void sendOOBControlMessage(IProvider provider, OOBControlMessage oobCtrlMsg) {
        for (IConsumer consumer : this.consumers) {
            try {
                consumer.onOOBControlMessage(provider, this, oobCtrlMsg);
            }
            catch (Throwable t) {
                log.error("exception when passing OOBCM from provider to consumers", t);
            }
        }
    }

    @Override
    public void sendOOBControlMessage(IConsumer consumer, OOBControlMessage oobCtrlMsg) {
        for (IProvider provider : this.providers) {
            try {
                provider.onOOBControlMessage(consumer, this, oobCtrlMsg);
            }
            catch (Throwable t) {
                log.error("exception when passing OOBCM from consumer to providers", t);
            }
        }
    }

    public List<IPipeConnectionListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public void setListeners(List<IPipeConnectionListener> newListeners) {
        this.listeners.clear();
        this.listeners.addAll(newListeners);
    }

    @Override
    public List<IProvider> getProviders() {
        return Collections.unmodifiableList(this.providers);
    }

    @Override
    public List<IConsumer> getConsumers() {
        return Collections.unmodifiableList(this.consumers);
    }

    protected void fireConsumerConnectionEvent(IConsumer consumer, PipeConnectionEvent.EventType type, Map<String, Object> paramMap) {
        this.firePipeConnectionEvent(PipeConnectionEvent.build(this, type, consumer, paramMap));
    }

    protected void fireProviderConnectionEvent(IProvider provider, PipeConnectionEvent.EventType type, Map<String, Object> paramMap) {
        this.firePipeConnectionEvent(PipeConnectionEvent.build(this, type, provider, paramMap));
    }

    protected void firePipeConnectionEvent(PipeConnectionEvent event) {
        for (IPipeConnectionListener element : this.listeners) {
            try {
                element.onPipeConnectionEvent(event);
            }
            catch (Throwable t) {
                log.error("Exception when handling pipe connection event", t);
            }
        }
        if (taskExecutor == null) {
            taskExecutor = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory("Pipe-"));
        }
        for (Runnable task : event.getTaskList()) {
            try {
                taskExecutor.execute(task);
            }
            catch (Throwable t) {
                log.warn("Exception executing pipe task {}", t);
            }
        }
        event.getTaskList().clear();
    }

    public void close() {
        if (this.consumers != null) {
            this.consumers.clear();
            this.consumers = null;
        }
        if (this.providers != null) {
            this.providers.clear();
            this.providers = null;
        }
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
    }
}

