/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.core.session.IoSession;
import org.red5.io.object.StreamAction;
import org.red5.server.api.Red5;
import org.red5.server.api.event.IEventDispatcher;
import org.red5.server.api.service.IPendingServiceCall;
import org.red5.server.api.service.IPendingServiceCallback;
import org.red5.server.api.stream.IClientStream;
import org.red5.server.net.ICommand;
import org.red5.server.net.IConnectionManager;
import org.red5.server.net.rtmp.Channel;
import org.red5.server.net.rtmp.IRTMPHandler;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.event.BytesRead;
import org.red5.server.net.rtmp.event.ChunkSize;
import org.red5.server.net.rtmp.event.ClientBW;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.event.Ping;
import org.red5.server.net.rtmp.event.ServerBW;
import org.red5.server.net.rtmp.event.Unknown;
import org.red5.server.net.rtmp.message.Constants;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.net.rtmp.message.Packet;
import org.red5.server.net.rtmp.status.StatusCodes;
import org.red5.server.so.SharedObjectMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRTMPHandler
implements IRTMPHandler,
Constants,
StatusCodes {
    private static Logger log = LoggerFactory.getLogger(BaseRTMPHandler.class);
    private static boolean isTrace = log.isTraceEnabled();
    private static boolean isDebug = log.isDebugEnabled();
    protected static final ExecutorService recvDispatchExecutor = Executors.newCachedThreadPool();

    @Override
    public void connectionOpened(RTMPConnection conn) {
        if (isTrace) {
            log.trace("connectionOpened - conn: {} state: {}", (Object)conn, (Object)conn.getState());
        }
        conn.open();
        conn.startWaitForHandshake();
    }

    @Override
    public void messageReceived(RTMPConnection conn, Packet packet) throws Exception {
        log.trace("messageReceived connection: {}", (Object)conn.getSessionId());
        if (conn != null) {
            IRTMPEvent message = packet.getMessage();
            try {
                Header header = packet.getHeader();
                Number streamId = header.getStreamId();
                Channel channel = conn.getChannel(header.getChannelId());
                IClientStream stream = conn.getStreamById(streamId);
                if (isTrace) {
                    log.trace("Message received - header: {}", (Object)header);
                }
                conn.setStreamId(streamId);
                conn.messageReceived();
                message.setSource(conn);
                byte headerDataType = header.getDataType();
                if (isTrace) {
                    log.trace("Header / message data type: {}", (Object)headerDataType);
                }
                switch (headerDataType) {
                    case 22: {
                        log.debug("Aggregate type data - header timer: {} size: {}", (Object)header.getTimer(), (Object)header.getSize());
                    }
                    case 8: 
                    case 9: {
                        message.setSourceType((byte)1);
                        if (stream == null) break;
                        EnsuresPacketExecutionOrder epeo = (EnsuresPacketExecutionOrder)conn.getAttribute("EnsuresPacketExecutionOrder");
                        if (epeo == null && stream != null) {
                            epeo = new EnsuresPacketExecutionOrder((IEventDispatcher)((Object)stream), conn);
                            conn.setAttribute("EnsuresPacketExecutionOrder", (Object)epeo);
                        }
                        epeo.addPacket(message);
                        break;
                    }
                    case 16: 
                    case 19: {
                        this.onSharedObject(conn, channel, header, (SharedObjectMessage)message);
                        break;
                    }
                    case 17: 
                    case 20: {
                        this.onCommand(conn, channel, header, (Invoke)message);
                        IPendingServiceCall call = ((Invoke)message).getCall();
                        if (message.getHeader().getStreamId().intValue() == 0 || call.getServiceName() != null || !StreamAction.PUBLISH.equals(call.getServiceMethodName()) || stream == null) break;
                        ((IEventDispatcher)((Object)stream)).dispatchEvent(message);
                        break;
                    }
                    case 15: 
                    case 18: {
                        if (((Notify)message).getData() != null && stream != null) {
                            EnsuresPacketExecutionOrder epeo = (EnsuresPacketExecutionOrder)conn.getAttribute("EnsuresPacketExecutionOrder");
                            if (epeo == null) {
                                epeo = new EnsuresPacketExecutionOrder((IEventDispatcher)((Object)stream), conn);
                                conn.setAttribute("EnsuresPacketExecutionOrder", (Object)epeo);
                            }
                            epeo.addPacket(message);
                            break;
                        }
                        this.onCommand(conn, channel, header, (Notify)message);
                        break;
                    }
                    case 4: {
                        this.onPing(conn, channel, header, (Ping)message);
                        break;
                    }
                    case 3: {
                        this.onStreamBytesRead(conn, channel, header, (BytesRead)message);
                        break;
                    }
                    case 1: {
                        this.onChunkSize(conn, channel, header, (ChunkSize)message);
                        break;
                    }
                    case 6: {
                        log.debug("Client bandwidth: {}", (Object)message);
                        this.onClientBandwidth(conn, channel, (ClientBW)message);
                        break;
                    }
                    case 5: {
                        log.debug("Server bandwidth: {}", (Object)message);
                        this.onServerBandwidth(conn, channel, (ServerBW)message);
                        break;
                    }
                    default: {
                        log.debug("Unknown type: {}", (Object)header.getDataType());
                    }
                }
                if (message instanceof Unknown) {
                    log.info("Message type unknown: {}", (Object)message);
                }
            }
            catch (Throwable t) {
                log.error("Exception", t);
            }
        }
    }

    @Override
    public void messageSent(RTMPConnection conn, Packet packet) {
        log.trace("Message sent");
        conn.messageSent(packet);
    }

    @Override
    public void connectionClosed(RTMPConnection conn) {
        IoSession session;
        log.debug("connectionClosed: {}", (Object)conn.getSessionId());
        if (conn.getStateCode() != 5) {
            conn.sendPendingServiceCallsCloseError();
            if (conn.getStateCode() != 4) {
                conn.close();
            }
            conn.setStateCode((byte)5);
        }
        if ((session = conn.getIoSession()) != null && session.containsAttribute((Object)"rtmp.connection.manager")) {
            IConnectionManager connManager = (IConnectionManager)((WeakReference)session.getAttribute((Object)"rtmp.connection.manager")).get();
            if (connManager != null) {
                connManager.removeConnection(conn.getSessionId());
            } else {
                log.debug("Connection manager was not found in the session");
            }
        }
        log.trace("connectionClosed: {}", (Object)conn);
    }

    protected String getHostname(String url) {
        String[] parts;
        if (isDebug) {
            log.debug("getHostname - url: {}", (Object)url);
        }
        if ((parts = url.split("/")).length == 2) {
            return "";
        }
        String host = parts[2];
        if (host.endsWith(":1935")) {
            return host.substring(0, host.length() - 5);
        }
        return host;
    }

    protected void handlePendingCallResult(RTMPConnection conn, Invoke invoke) {
        IPendingServiceCall call = invoke.getCall();
        IPendingServiceCall pendingCall = conn.retrievePendingCall(invoke.getTransactionId());
        if (pendingCall != null) {
            Set<IPendingServiceCallback> callbacks;
            Object[] args = call.getArguments();
            if (args != null && args.length > 0) {
                pendingCall.setResult(args[0]);
            }
            if (!(callbacks = pendingCall.getCallbacks()).isEmpty()) {
                HashSet<IPendingServiceCallback> tmp = new HashSet<IPendingServiceCallback>();
                tmp.addAll(callbacks);
                for (IPendingServiceCallback callback : tmp) {
                    try {
                        callback.resultReceived(pendingCall);
                    }
                    catch (Exception e) {
                        log.error("Error while executing callback {}", (Object)callback, (Object)e);
                    }
                }
            }
        }
    }

    protected abstract void onChunkSize(RTMPConnection var1, Channel var2, Header var3, ChunkSize var4);

    protected abstract void onCommand(RTMPConnection var1, Channel var2, Header var3, ICommand var4);

    protected abstract void onPing(RTMPConnection var1, Channel var2, Header var3, Ping var4);

    protected void onServerBandwidth(RTMPConnection conn, Channel channel, ServerBW message) {
    }

    protected void onClientBandwidth(RTMPConnection conn, Channel channel, ClientBW message) {
    }

    protected void onStreamBytesRead(RTMPConnection conn, Channel channel, Header source, BytesRead streamBytesRead) {
        conn.receivedBytesRead(streamBytesRead.getBytesRead());
    }

    protected abstract void onSharedObject(RTMPConnection var1, Channel var2, Header var3, SharedObjectMessage var4);

    private static class EnsuresPacketExecutionOrder
    implements Runnable {
        public static final String ATTRIBUTE_NAME = "EnsuresPacketExecutionOrder";
        private LinkedBlockingQueue<IRTMPEvent> events = new LinkedBlockingQueue();
        private AtomicBoolean state = new AtomicBoolean();
        private final IEventDispatcher stream;
        private final RTMPConnection conn;
        private int iter;

        public EnsuresPacketExecutionOrder(IEventDispatcher stream, RTMPConnection conn) {
            this.stream = stream;
            this.conn = conn;
        }

        public void addPacket(IRTMPEvent packet) {
            this.events.offer(packet);
            if (this.state.compareAndSet(false, true)) {
                recvDispatchExecutor.submit(this);
            }
        }

        @Override
        public void run() {
            Thread.currentThread().setName(String.format("RTMPRecvDispatch@%s-%d", this.conn.getSessionId(), this.iter++));
            this.iter &= 7;
            Red5.setConnectionLocal(this.conn);
            IRTMPEvent message = this.events.poll();
            if (message != null) {
                this.stream.dispatchEvent(message);
                message.release();
            }
            Red5.setConnectionLocal(null);
            if (!this.events.isEmpty()) {
                recvDispatchExecutor.submit(this);
            } else {
                this.state.set(false);
            }
        }
    }
}

