/*
 * Decompiled with CFR 0.152.
 */
package org.red5.codec;

import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.AbstractVideo;
import org.red5.codec.IVideoStreamCodec;
import org.red5.codec.VideoCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AV1Video
extends AbstractVideo {
    private static Logger log = LoggerFactory.getLogger(AV1Video.class);
    static final String CODEC_NAME = "AV1";
    public static final byte[] AV1_KEYFRAME_PREFIX = new byte[]{10, 1};
    public static final byte[] AV1_FRAME_PREFIX = new byte[]{42, 1};
    private IoBuffer obuBuffer;

    @Override
    public String getName() {
        return CODEC_NAME;
    }

    @Override
    public boolean canDropFrames() {
        return true;
    }

    @Override
    public boolean canHandleData(IoBuffer data) {
        if (data.hasRemaining()) {
            byte first = data.get();
            data.rewind();
            return (first & 0xF) == VideoCodec.AV1.getId();
        }
        return false;
    }

    @Override
    public boolean addData(IoBuffer data, int timestamp) {
        return this.addData(data, timestamp, true);
    }

    @Override
    public boolean addData(IoBuffer data, int timestamp, boolean amf) {
        log.trace("addData timestamp: {} remaining: {} amf? {}", new Object[]{timestamp, data.remaining(), amf});
        if (data.hasRemaining()) {
            int start = data.position();
            if (!amf) {
                int remaining = data.remaining();
                if (remaining > 7) {
                    byte[] peek = new byte[8];
                    data.get(peek);
                    boolean isKey = this.isKeyFrame(peek, 0);
                    data.position(start);
                    IoBuffer slice = data.getSlice(start, remaining);
                    log.info("Data start: {} post-slice: {}", (Object)start, (Object)data.position());
                    data.expand(remaining + 2);
                    if (isKey) {
                        data.put(AV1_KEYFRAME_PREFIX);
                    } else {
                        data.put(AV1_FRAME_PREFIX);
                    }
                    data.put(slice);
                    data.flip();
                    start = data.position();
                } else {
                    log.warn("Remaining AV1 content was less than expected: {}", (Object)remaining);
                }
                data.position(start);
            }
            byte frameType = data.get();
            byte subFrameType = data.get();
            if ((frameType & 0xF) == VideoCodec.AV1.getId()) {
                if ((frameType & 0xF0) == 16) {
                    if (log.isDebugEnabled()) {
                        log.debug("Keyframe - AV1 type: {}", (Object)subFrameType);
                    }
                    data.rewind();
                    switch (subFrameType) {
                        case 1: {
                            if (timestamp != this.keyframeTimestamp) {
                                this.keyframeTimestamp = timestamp;
                                this.keyframes.clear();
                            }
                            this.keyframes.add(new IVideoStreamCodec.FrameData(data));
                            break;
                        }
                    }
                }
            } else {
                log.debug("Non-AV1 data, rejecting");
                data.position(start);
                return false;
            }
            data.position(start);
        }
        return true;
    }

    private boolean isKeyFrame(byte[] data, int index) {
        return true;
    }
}

