/*
 * Decompiled with CFR 0.152.
 */
package org.red5.codec;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum VideoCodec {
    JPEG(1),
    H263(2),
    SCREEN_VIDEO(3),
    VP6(4),
    VP6a(5),
    SCREEN_VIDEO2(6),
    AVC(7),
    VP8(8),
    VP9(9),
    AV1(10),
    MPEG1(11),
    HEVC(12);

    private static final EnumSet<VideoCodec> configured;
    private static final Map<Byte, VideoCodec> map;
    private byte id;

    private VideoCodec(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    public static VideoCodec valueOfById(int id) {
        return map.get((byte)id);
    }

    public static EnumSet<VideoCodec> getConfigured() {
        return configured;
    }

    static {
        configured = EnumSet.of(AVC, HEVC, VP8, VP9, AV1);
        map = new HashMap<Byte, VideoCodec>();
        for (VideoCodec codec : VideoCodec.values()) {
            map.put(codec.id, codec);
        }
    }
}

