/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.object;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.red5.io.client.IRemotingClient;
import org.red5.io.object.Input;
import org.red5.io.object.RecordSetPage;

public class RecordSet {
    private static final String MODE_ONDEMAND = "ondemand";
    private static final String MODE_FETCHALL = "fetchall";
    private static final String MODE_PAGE = "page";
    private int totalCount;
    private List<List<Object>> data;
    private int cursor;
    private String serviceName;
    private List<String> columns;
    private int version;
    private Object id;
    private IRemotingClient client;
    private String mode = "ondemand";
    private int pageSize = 25;

    public RecordSet(Input input) {
        Map<String, Object> dataMap = input.readKeyValues();
        Object map = dataMap.get("serverinfo");
        Map serverInfo = null;
        if (map != null) {
            if (!(map instanceof Map)) {
                throw new RuntimeException("Expected Map but got " + map.getClass().getName());
            }
            serverInfo = (Map)map;
            this.totalCount = (Integer)serverInfo.get("totalCount");
            List initialData = (List)serverInfo.get("initialData");
            this.cursor = (Integer)serverInfo.get("cursor");
            this.serviceName = (String)serverInfo.get("serviceName");
            this.columns = (List)serverInfo.get("columnNames");
            this.version = (Integer)serverInfo.get("version");
            this.id = serverInfo.get("id");
            this.data = new ArrayList<List<Object>>(this.totalCount);
            for (int i = 0; i < initialData.size(); ++i) {
                this.data.add(i + this.cursor - 1, (List)initialData.get(i));
            }
        } else {
            throw new RuntimeException("Map (serverinfo) was null");
        }
    }

    public void setRemotingClient(IRemotingClient client) {
        this.client = client;
    }

    public void setDeliveryMode(String mode) {
        this.setDeliveryMode(mode, 25, 0);
    }

    public void setDeliveryMode(String mode, int pageSize) {
        this.setDeliveryMode(mode, pageSize, 0);
    }

    public void setDeliveryMode(String mode, int pageSize, int prefetchCount) {
        this.mode = mode;
        this.pageSize = pageSize;
    }

    public List<String> getColumnNames() {
        return Collections.unmodifiableList(this.columns);
    }

    private void ensureAvailable(int index) {
        int count;
        if (this.data.get(index) != null) {
            return;
        }
        if (this.client == null) {
            throw new RuntimeException("no remoting client configured");
        }
        int start = index;
        if (this.mode.equals(MODE_ONDEMAND)) {
            count = 1;
        } else if (this.mode.equals(MODE_FETCHALL)) {
            count = this.totalCount - this.cursor;
        } else if (this.mode.equals(MODE_PAGE)) {
            count = 1;
            for (int i = 1; i < this.pageSize; ++i) {
                if (this.data.get(start + i) != null) continue;
                ++count;
            }
        } else {
            count = 1;
        }
        Object result = this.client.invokeMethod(this.serviceName + ".getRecords", new Object[]{this.id, start + 1, count});
        if (!(result instanceof RecordSetPage)) {
            throw new RuntimeException("expected RecordSetPage but got " + result);
        }
        RecordSetPage page = (RecordSetPage)result;
        if (page.getCursor() != start + 1) {
            throw new RuntimeException("expected offset " + (start + 1) + " but got " + page.getCursor());
        }
        List<List<Object>> data = page.getData();
        if (data.size() != count) {
            throw new RuntimeException("expected " + count + " results but got " + data.size());
        }
        for (int i = 0; i < count; ++i) {
            this.data.add(start + i, data.get(i));
        }
    }

    public List<Object> getItemAt(int index) {
        if (index < 0 || index >= this.totalCount) {
            return null;
        }
        this.ensureAvailable(index);
        return this.data.get(index);
    }

    public int getLength() {
        return this.totalCount;
    }

    public int getNumberAvailable() {
        int result = 0;
        for (int i = 0; i < this.data.size(); ++i) {
            if (this.data.get(i) == null) continue;
            ++result;
        }
        return result;
    }

    public boolean isFullyPopulated() {
        return this.getNumberAvailable() == this.getLength();
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> serverInfo = new HashMap<String, Object>();
        serverInfo.put("totalCount", this.totalCount);
        serverInfo.put("cursor", this.cursor);
        serverInfo.put("serviceName", this.serviceName);
        serverInfo.put("columnNames", this.columns);
        serverInfo.put("version", this.version);
        serverInfo.put("id", this.id);
        serverInfo.put("initialData", this.data);
        return serverInfo;
    }
}

