/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Stream;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.red5.net.websocket.WebSocketPlugin;
import org.red5.net.websocket.WebSocketScope;
import org.red5.net.websocket.WebSocketScopeManager;
import org.red5.net.websocket.listener.IWebSocketDataListener;
import org.red5.net.websocket.server.HandshakeModifier;
import org.red5.server.api.scope.IScope;
import org.red5.server.plugin.PluginRegistry;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServerEndpointConfigurator
extends ServerEndpointConfig.Configurator {
    private final Logger log = LoggerFactory.getLogger(DefaultServerEndpointConfigurator.class);
    private IScope applicationScope;
    private boolean crossOriginPolicy = WebSocketPlugin.isCrossOriginPolicy();
    private String[] allowedOrigins = WebSocketPlugin.getAllowedOrigins();
    private CopyOnWriteArraySet<HandshakeModifier> handshakeModifiers = new CopyOnWriteArraySet();

    public <T> T getEndpointInstance(Class<T> clazz) throws InstantiationException {
        this.log.debug("getEndpointInstance: {}", (Object)clazz.getName());
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw e;
        }
        catch (ReflectiveOperationException e) {
            InstantiationException ie = new InstantiationException();
            ie.initCause(e);
            throw ie;
        }
    }

    public String getNegotiatedSubprotocol(List<String> supported, List<String> requested) {
        this.log.debug("getNegotiatedSubprotocol - supported: {} requested: {}", (Object)supported, (Object)requested);
        if (supported.contains("*")) {
            return requested.isEmpty() ? "" : requested.get(0);
        }
        for (String request : requested) {
            if (!supported.contains(request)) continue;
            return request;
        }
        return "";
    }

    public List<Extension> getNegotiatedExtensions(List<Extension> installed, List<Extension> requested) {
        this.log.debug("getNegotiatedExtensions - installed: {} requested: {}", (Object)installed, (Object)requested);
        HashSet<String> installedNames = new HashSet<String>();
        for (Extension e : installed) {
            installedNames.add(e.getName());
        }
        ArrayList<Extension> result = new ArrayList<Extension>();
        for (Extension request : requested) {
            if (!installedNames.contains(request.getName())) continue;
            result.add(request);
        }
        return result;
    }

    public boolean checkOrigin(String originHeaderValue) {
        this.log.debug("checkOrigin: {}", (Object)originHeaderValue);
        if (this.crossOriginPolicy) {
            this.log.debug("allowedOrigins: {}", (Object)Arrays.toString(this.allowedOrigins));
            Optional<String> opt = Stream.of(this.allowedOrigins).filter(origin -> "*".equals(origin) || origin.endsWith(originHeaderValue)).findFirst();
            if (!opt.isPresent()) {
                this.log.info("Origin: {} did not match the allowed: {}", (Object)originHeaderValue, (Object)this.allowedOrigins);
                return false;
            }
        }
        return true;
    }

    public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
        WebSocketPlugin plugin;
        WebSocketScopeManager manager;
        String path = request.getRequestURI().toString();
        this.log.debug("Request URI: {}", (Object)path);
        if (path.startsWith("wss")) {
            path = path.substring(6);
            path = path.substring(path.indexOf(47));
        } else if (path.startsWith("ws")) {
            path = path.substring(5);
            path = path.substring(path.indexOf(47));
        }
        this.log.debug("Stripped path: {}", (Object)path);
        int idx = -1;
        idx = path.lastIndexOf(47);
        if (idx != -1) {
            path = path.substring(0, idx);
        }
        if ((manager = (plugin = (WebSocketPlugin)PluginRegistry.getPlugin("WebSocketPlugin")).getManager(path)) != null) {
            sec.getUserProperties().put("ws.manager", manager);
            WebSocketScope scope = manager.getScope(path);
            this.log.debug("WebSocketScope: {}", (Object)scope);
            if (scope == null) {
                IScope appScope;
                Object[] paths = path.split("\\/");
                IScope parentScope = appScope = Optional.ofNullable(this.applicationScope).orElse(plugin.getApplicationScope(path));
                IScope roomScope = null;
                this.log.debug("Creating child websocket scope of {} for path: {} split: {}", this.applicationScope, path, Arrays.toString(paths));
                for (int i = 2; i < paths.length; ++i) {
                    roomScope = ScopeUtils.resolveScope(parentScope, (String)paths[i]);
                    if (roomScope == null && parentScope.createChildScope((String)paths[i])) {
                        roomScope = ScopeUtils.resolveScope(parentScope, (String)paths[i]);
                    }
                    this.log.debug("Parent scope: {} room scope: {}", (Object)parentScope, (Object)roomScope);
                    parentScope = roomScope;
                }
                manager.makeScope(roomScope);
                scope = manager.getScope(path);
                Set<IWebSocketDataListener> listeners = ((WebSocketScope)appScope.getAttribute("ws.scope")).getListeners();
                for (IWebSocketDataListener listener : listeners) {
                    this.log.debug("Adding listener: {}", (Object)listener);
                    scope.addListener(listener);
                }
            }
            sec.getUserProperties().put("ws.scope", scope);
            this.handshakeModifiers.forEach(modifier -> modifier.modifyHandshake(request, response));
        } else {
            this.log.warn("No websocket manager found for path: {} requested uri: {}", (Object)path, (Object)request.getRequestURI().toString());
        }
        super.modifyHandshake(sec, request, response);
    }

    public IScope getApplicationScope() {
        return this.applicationScope;
    }

    public void setApplicationScope(IScope applicationScope) {
        this.applicationScope = applicationScope;
    }

    public boolean isCrossOriginPolicy() {
        return this.crossOriginPolicy;
    }

    public void setCrossOriginPolicy(boolean crossOriginPolicy) {
        this.crossOriginPolicy = crossOriginPolicy;
    }

    public String[] getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(String[] allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        this.log.debug("allowedOrigins: {}", (Object)Arrays.toString(allowedOrigins));
    }

    public boolean addHandshakeModifier(HandshakeModifier modifier) {
        return this.handshakeModifiers.add(modifier);
    }

    public boolean removeHandshakeModifier(HandshakeModifier modifier) {
        return this.handshakeModifiers.remove(modifier);
    }
}

