/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket.server;

import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.net.websocket.WebSocketConnection;
import org.red5.net.websocket.WebSocketScope;
import org.red5.net.websocket.model.WSMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebSocketEndpoint
extends Endpoint {
    private final Logger log = LoggerFactory.getLogger(DefaultWebSocketEndpoint.class);
    private final boolean isDebug = this.log.isDebugEnabled();
    private final boolean isTrace = this.log.isTraceEnabled();
    private WebSocketScope scope;

    public void onOpen(Session session, EndpointConfig config) {
        this.log.debug("Session opened: {}\n{}", (Object)session.getId(), (Object)session.getRequestParameterMap());
        this.scope = (WebSocketScope)config.getUserProperties().get("ws.scope");
        WebSocketConnection conn = (WebSocketConnection)session.getUserProperties().get("ws.connection");
        if (conn == null) {
            this.log.warn("WebSocketConnection null at onOpen for {}", (Object)session.getId());
        }
        session.setMaxTextMessageBufferSize(10000);
        session.addMessageHandler((MessageHandler)new WholeMessageHandler(conn));
        session.addMessageHandler((MessageHandler)new WholeBinaryHandler(conn));
        session.addMessageHandler((MessageHandler)new WholePongHandler(conn));
    }

    public void onClose(Session session, CloseReason closeReason) {
        block6: {
            String sessionId = session.getId();
            this.log.debug("Session closed: {}", (Object)sessionId);
            WebSocketConnection conn = null;
            try {
                conn = (WebSocketConnection)session.getUserProperties().get("ws.connection");
                if (conn == null) {
                    this.log.warn("Connection for id: {} was not found in the session onClose", (Object)sessionId);
                    conn = this.scope.getConnectionBySessionId(sessionId);
                }
                if (conn != null) {
                    if (conn.isConnected()) {
                        conn.close();
                    }
                } else {
                    this.log.debug("Connection for id: {} was not found in the scope or session: {}", (Object)sessionId, (Object)this.scope.getPath());
                }
            }
            catch (Exception e) {
                if (conn == null) break block6;
                this.scope.removeConnection(conn);
                conn.close();
            }
        }
    }

    public void onError(Session session, Throwable t) {
        Throwable root = t;
        for (int count = 0; root.getCause() != null && count < 20; ++count) {
            root = root.getCause();
        }
        if (root instanceof EOFException) {
            this.log.debug("EOF exception", root);
        } else if (root instanceof IOException) {
            this.log.debug("IO exception when opened? {}", (Object)session.isOpen(), (Object)root);
        } else {
            this.log.debug("onError: {}", (Object)t.toString(), (Object)t);
            this.onClose(session, new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, t.getMessage()));
        }
    }

    private class WholePongHandler
    implements MessageHandler.Whole<PongMessage> {
        final WebSocketConnection conn;

        WholePongHandler(WebSocketConnection conn) {
            this.conn = conn;
        }

        public void onMessage(PongMessage message) {
            if (DefaultWebSocketEndpoint.this.isTrace) {
                DefaultWebSocketEndpoint.this.log.trace("Pong received {}", (Object)message);
            }
            if (this.conn != null && this.conn.isConnected()) {
                this.conn.updateReadBytes(1L);
            }
        }
    }

    private class WholeBinaryHandler
    implements MessageHandler.Whole<ByteBuffer> {
        final WebSocketConnection conn;

        WholeBinaryHandler(WebSocketConnection conn) {
            this.conn = conn;
        }

        public void onMessage(ByteBuffer message) {
            if (DefaultWebSocketEndpoint.this.isTrace) {
                DefaultWebSocketEndpoint.this.log.trace("Message received {}", (Object)message);
            }
            if (this.conn != null && this.conn.isConnected()) {
                this.conn.updateReadBytes(message.limit());
                WSMessage wsMessage = new WSMessage();
                wsMessage.setPayload(IoBuffer.wrap(message));
                wsMessage.setConnection(this.conn);
                DefaultWebSocketEndpoint.this.scope.onMessage(wsMessage);
            } else {
                DefaultWebSocketEndpoint.this.log.debug("Connection null or not connected", (Object)this.conn);
            }
        }
    }

    private class WholeMessageHandler
    implements MessageHandler.Whole<String> {
        final WebSocketConnection conn;

        WholeMessageHandler(WebSocketConnection conn) {
            this.conn = conn;
        }

        public void onMessage(String message) {
            if (DefaultWebSocketEndpoint.this.isTrace) {
                DefaultWebSocketEndpoint.this.log.trace("Message received {}", (Object)message);
            }
            if (this.conn != null && this.conn.isConnected()) {
                try {
                    this.conn.updateReadBytes(message.getBytes().length);
                    WSMessage wsMessage = new WSMessage(message);
                    wsMessage.setConnection(this.conn);
                    DefaultWebSocketEndpoint.this.scope.onMessage(wsMessage);
                }
                catch (UnsupportedEncodingException e) {
                    DefaultWebSocketEndpoint.this.log.warn("Exception on message", e);
                }
            } else {
                DefaultWebSocketEndpoint.this.log.debug("Connection null or not connected", (Object)this.conn);
            }
        }
    }
}

