/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmpe;

import java.util.Optional;
import javax.crypto.Cipher;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.red5.server.net.rtmp.InboundHandshake;
import org.red5.server.net.rtmp.RTMPConnManager;
import org.red5.server.net.rtmp.RTMPMinaConnection;
import org.red5.server.net.rtmp.ReadBuffer;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmpe.EncryptedWriteRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMPEIoFilter
extends IoFilterAdapter {
    private static final Logger log = LoggerFactory.getLogger(RTMPEIoFilter.class);
    private static boolean isDebug = log.isDebugEnabled();
    private static boolean isTrace = log.isTraceEnabled();

    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object obj) throws Exception {
        String sessionId;
        if (isTrace) {
            log.trace("messageReceived nextFilter: {} session: {} message: {}", nextFilter, session, obj);
        }
        if ((sessionId = (String)session.getAttribute("rtmp.sessionid")) != null) {
            RTMPMinaConnection conn;
            if (isTrace) {
                log.trace("RTMP Session id: {}", (Object)sessionId);
            }
            if ((conn = (RTMPMinaConnection)RTMPConnManager.getInstance().getConnectionBySessionId(sessionId)) == null) {
                throw new Exception("Receive on unavailable connection - session id: " + sessionId);
            }
            byte connectionState = conn.getStateCode();
            ReadBuffer buffer = Optional.ofNullable((ReadBuffer)session.getAttribute("rtmp.buffer")).orElseGet(() -> {
                session.setAttribute("rtmp.buffer", new ReadBuffer());
                return (ReadBuffer)session.getAttribute("rtmp.buffer");
            });
            buffer.addBuffer((IoBuffer)obj);
            InboundHandshake handshake = session.containsAttribute("rtmp.handshake") ? (InboundHandshake)session.getAttribute("rtmp.handshake") : null;
            switch (connectionState) {
                case 0: {
                    int c0c1Size = buffer.getBufferSize();
                    log.trace("Incoming C0C1 size: {}", (Object)c0c1Size);
                    if (c0c1Size < 1537) break;
                    log.debug("decodeHandshakeC0C1");
                    byte[] dst = buffer.getBuffer(1537);
                    byte connectionType = dst[0];
                    handshake.setHandshakeType(connectionType);
                    log.trace("Incoming C0 connection type: {}", (Object)connectionType);
                    IoBuffer decBuffer = IoBuffer.wrap(dst);
                    decBuffer.get();
                    IoBuffer s1 = handshake.decodeClientRequest1(decBuffer);
                    if (s1 != null) {
                        conn.setStateCode((byte)1);
                        session.write(s1);
                        break;
                    }
                    log.warn("Client was rejected due to invalid handshake");
                    conn.close();
                    break;
                }
                case 1: {
                    int c2Size = buffer.getBufferSize();
                    log.trace("Incoming C2 size: {}", (Object)c2Size);
                    if (c2Size < 1536) break;
                    log.debug("decodeHandshakeC2");
                    byte[] dst = buffer.getBuffer(1536);
                    if (handshake.decodeClientRequest2(IoBuffer.wrap(dst))) {
                        log.debug("Connected");
                        conn.setStateCode((byte)2);
                        session.removeAttribute("rtmp.handshake");
                        if (handshake.useEncryption()) {
                            log.debug("Using encrypted communications, adding ciphers to the session");
                            conn.setEncrypted(true);
                            session.setAttribute("rtmpe.cipher.in", handshake.getCipherIn());
                            session.setAttribute("rtmpe.cipher.out", handshake.getCipherOut());
                        }
                    } else {
                        log.warn("Client was rejected due to invalid handshake");
                        conn.close();
                    }
                }
                case 2: {
                    if (buffer.getBufferSize() <= 0) break;
                    IoBuffer message = buffer.getBufferAsIoBuffer();
                    if (!conn.isEncrypted()) {
                        log.trace("Receiving message: {}", (Object)message);
                        nextFilter.messageReceived(session, message);
                        break;
                    }
                    Cipher cipher = (Cipher)session.getAttribute("rtmpe.cipher.in");
                    if (cipher == null) break;
                    if (isDebug) {
                        log.debug("Decrypting message: {}", (Object)message);
                    }
                    byte[] encrypted = new byte[message.remaining()];
                    message.get(encrypted);
                    message.free();
                    byte[] plain = cipher.update(encrypted);
                    IoBuffer messageDecrypted = IoBuffer.wrap(plain);
                    if (isDebug) {
                        log.debug("Receiving decrypted message: {}", (Object)messageDecrypted);
                    }
                    nextFilter.messageReceived(session, messageDecrypted);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    log.debug("Nothing to do, connection state: {}", (Object)RTMP.states[connectionState]);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid RTMP state: " + connectionState);
                }
            }
        }
    }

    @Override
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest request) throws Exception {
        log.trace("filterWrite nextFilter: {} session: {} request: {}", nextFilter, session, request);
        Cipher cipher = (Cipher)session.getAttribute("rtmpe.cipher.out");
        if (cipher == null) {
            if (isTrace) {
                log.trace("Writing message");
            }
            nextFilter.filterWrite(session, request);
        } else {
            IoBuffer message = (IoBuffer)request.getMessage();
            if (message.hasRemaining()) {
                if (isDebug) {
                    log.debug("Encrypting message: {}", (Object)message);
                }
                byte[] plain = new byte[message.remaining()];
                message.get(plain);
                message.free();
                byte[] encrypted = cipher.update(plain);
                IoBuffer messageEncrypted = IoBuffer.wrap(encrypted);
                if (isDebug) {
                    log.debug("Writing encrypted message: {}", (Object)messageEncrypted);
                }
                nextFilter.filterWrite(session, new EncryptedWriteRequest(request, messageEncrypted));
            }
        }
    }
}

