/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.scope;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletContext;
import org.red5.server.LoaderBase;
import org.red5.server.api.IApplicationContext;
import org.red5.server.api.IApplicationLoader;
import org.red5.server.api.IConnection;
import org.red5.server.api.IServer;
import org.red5.server.api.scope.IGlobalScope;
import org.red5.server.api.scope.ScopeType;
import org.red5.server.jmx.mxbeans.WebScopeMXBean;
import org.red5.server.scope.Scope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.web.context.ServletContextAware;

@ManagedResource
public class WebScope
extends Scope
implements ServletContextAware,
WebScopeMXBean,
InitializingBean,
DisposableBean {
    protected static Logger log = LoggerFactory.getLogger(WebScope.class);
    protected transient IServer server;
    protected transient IApplicationContext appContext;
    protected transient IApplicationLoader appLoader;
    protected transient ServletContext servletContext;
    protected String contextPath;
    protected String virtualHosts;
    protected String[] hostnames;
    protected AtomicBoolean registered = new AtomicBoolean(false);
    protected AtomicBoolean shuttingDown = new AtomicBoolean(false);

    public WebScope() {
        this.type = ScopeType.APPLICATION;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.register();
    }

    @Override
    public void destroy() throws Exception {
        this.unregister();
        super.destroy();
    }

    public void setGlobalScope(IGlobalScope globalScope) {
        log.trace("Set global scope: {}", (Object)globalScope);
        super.setParent(globalScope);
        try {
            this.setPersistenceClass(globalScope.getStore().getClass().getName());
        }
        catch (Exception error) {
            log.error("Could not set persistence class.", error);
        }
    }

    public void setName() {
        throw new RuntimeException("Cannot set name, you must set context path");
    }

    public void setParent() {
        throw new RuntimeException("Cannot set parent, you must set global scope");
    }

    public void setServer(IServer server) {
        log.info("Set server {}", (Object)server);
        this.server = server;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
        super.setName(contextPath.substring(1));
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public void setVirtualHosts(String virtualHosts) {
        this.virtualHosts = virtualHosts;
        this.hostnames = virtualHosts.split(",");
        for (int i = 0; i < this.hostnames.length; ++i) {
            this.hostnames[i] = this.hostnames[i].trim();
            if (!this.hostnames[i].equals("*")) continue;
            this.hostnames[i] = "";
        }
    }

    @Override
    public void register() {
        if (this.registered.compareAndSet(false, true)) {
            log.debug("Webscope registering: {}", (Object)this.contextPath);
            this.getAppContext();
            this.appLoader = LoaderBase.getApplicationLoader();
            String parentName = this.getParent().getName();
            if (this.hostnames != null && this.hostnames.length > 0) {
                for (String hostName : this.hostnames) {
                    this.server.addMapping(hostName, this.getName(), parentName);
                }
            }
            this.init();
            this.keepOnDisconnect = true;
        } else {
            log.info("Webscope already registered; remove the 'init-method' from your 'web.scope' bean to prevent this message in the future.");
        }
    }

    @Override
    public void unregister() {
        if (!this.registered.compareAndSet(true, false)) {
            log.info("Webscope not registered");
            return;
        }
        log.debug("Webscope un-registering: {}", (Object)this.contextPath);
        if (this.shuttingDown.compareAndSet(false, true)) {
            this.keepOnDisconnect = false;
            this.uninit();
            Set<IConnection> conns = this.getClientConnections();
            for (IConnection conn : conns) {
                conn.close();
            }
            conns.clear();
            if (this.hostnames != null && this.hostnames.length > 0) {
                for (String element : this.hostnames) {
                    this.server.removeMapping(element, this.getName());
                }
            }
            if (this.appContext == null) {
                log.debug("Application context is null, trying retrieve from loader");
                this.getAppContext();
            }
            if (this.appContext != null) {
                log.debug("Stopping app context");
                this.appContext.stop();
            } else {
                log.debug("Application context is null, could not be stopped");
            }
            this.store = null;
            this.setServletContext(null);
            this.setServer(null);
            this.appContext = null;
            this.shuttingDown.set(false);
        } else {
            log.info("Webscope is currently shutting down");
        }
    }

    @Override
    public IServer getServer() {
        return this.server;
    }

    public IApplicationLoader getApplicationLoader() {
        return this.appLoader;
    }

    private final void getAppContext() {
        ServletContext sctx;
        String hostId = null;
        if (this.servletContext != null && (sctx = this.servletContext.getContext(this.contextPath)) != null) {
            hostId = (String)sctx.getAttribute("red5.host.id");
            log.trace("Host id from init param: {}", (Object)hostId);
        }
        this.appContext = hostId != null ? LoaderBase.getRed5ApplicationContext(hostId + this.contextPath) : LoaderBase.getRed5ApplicationContext(this.contextPath);
    }

    @Override
    public boolean isShuttingDown() {
        return this.shuttingDown.get();
    }
}

