/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.flv.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.AudioCodec;
import org.red5.codec.VideoCodec;
import org.red5.io.BufferType;
import org.red5.io.IKeyFrameMetaCache;
import org.red5.io.IStreamableFile;
import org.red5.io.ITag;
import org.red5.io.ITagReader;
import org.red5.io.IoConstants;
import org.red5.io.amf.Input;
import org.red5.io.amf.Output;
import org.red5.io.flv.FLVHeader;
import org.red5.io.flv.IKeyFrameDataAnalyzer;
import org.red5.io.flv.impl.Tag;
import org.red5.io.object.Deserializer;
import org.red5.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLVReader
implements IoConstants,
ITagReader,
IKeyFrameDataAnalyzer {
    private static Logger log = LoggerFactory.getLogger(FLVReader.class);
    private File file;
    private FileInputStream fis;
    private FileChannel channel;
    private long channelSize;
    private IKeyFrameDataAnalyzer.KeyFrameMeta keyframeMeta;
    private IoBuffer in;
    private boolean generateMetadata;
    private long firstVideoTag = -1L;
    private long firstAudioTag = -1L;
    private AtomicBoolean audioConfigRead = new AtomicBoolean(false);
    private AtomicBoolean videoConfigRead = new AtomicBoolean(false);
    private boolean metadataSent = false;
    private long duration;
    private HashMap<Long, Long> posTimeMap;
    private static BufferType bufferType = BufferType.AUTO;
    private static int bufferSize = 1024;
    private boolean useLoadBuf;
    private static IKeyFrameMetaCache keyframeCache;
    private FLVHeader header;
    private final ReentrantLock lock = new ReentrantLock();

    FLVReader() {
    }

    public FLVReader(File f) throws IOException {
        this(f, false);
    }

    public FLVReader(File f, boolean generateMetadata) throws IOException {
        if (null == f) {
            log.warn("Reader was passed a null file");
            log.debug("{}", (Object)ToStringBuilder.reflectionToString((Object)this));
        }
        this.file = f;
        this.fis = new FileInputStream(f);
        this.generateMetadata = generateMetadata;
        this.channel = this.fis.getChannel();
        this.channelSize = this.channel.size();
        this.in = null;
        this.fillBuffer();
        this.postInitialize();
    }

    public FLVReader(FileChannel channel) throws IOException {
        if (null == channel) {
            log.warn("Reader was passed a null channel");
            log.debug("{}", (Object)ToStringBuilder.reflectionToString((Object)this));
        }
        if (!channel.isOpen()) {
            log.warn("Reader was passed a closed channel");
            return;
        }
        this.channel = channel;
        this.channelSize = channel.size();
        log.debug("Channel size: {}", (Object)this.channelSize);
        if (channel.position() > 0L) {
            log.debug("Channel position: {}", (Object)channel.position());
            channel.position(0L);
        }
        this.fillBuffer();
        this.postInitialize();
    }

    public FLVReader(IoBuffer buffer, boolean generateMetadata) {
        this.generateMetadata = generateMetadata;
        this.in = buffer;
        this.postInitialize();
    }

    public void setKeyFrameCache(IKeyFrameMetaCache keyframeCache) {
        FLVReader.keyframeCache = keyframeCache;
    }

    private long getRemainingBytes() {
        if (this.in != null) {
            if (!this.useLoadBuf) {
                return this.in.remaining();
            }
            try {
                if (this.channel.isOpen()) {
                    return this.channelSize - this.channel.position() + (long)this.in.remaining();
                }
                return this.in.remaining();
            }
            catch (Exception e) {
                log.error("Error getRemainingBytes", (Throwable)e);
            }
        }
        return 0L;
    }

    @Override
    public long getTotalBytes() {
        if (!this.useLoadBuf) {
            return this.in.capacity();
        }
        try {
            return this.channelSize;
        }
        catch (Exception e) {
            log.error("Error getTotalBytes", (Throwable)e);
            return 0L;
        }
    }

    private long getCurrentPosition() {
        if (!this.useLoadBuf) {
            return this.in.position();
        }
        try {
            long pos = this.in != null ? this.channel.position() - (long)this.in.remaining() : this.channel.position();
            return pos;
        }
        catch (Exception e) {
            log.error("Error getCurrentPosition", (Throwable)e);
            return 0L;
        }
    }

    private void setCurrentPosition(long pos) {
        if (pos == Long.MAX_VALUE) {
            pos = this.file.length();
        }
        if (!this.useLoadBuf) {
            this.in.position((int)pos);
            return;
        }
        try {
            if (pos >= this.channel.position() - (long)this.in.limit() && pos < this.channel.position()) {
                this.in.position((int)(pos - (this.channel.position() - (long)this.in.limit())));
            } else {
                this.channel.position(pos);
                this.fillBuffer(bufferSize, true);
            }
        }
        catch (Exception e) {
            log.error("Error setCurrentPosition", (Throwable)e);
        }
    }

    private void fillBuffer() {
        this.fillBuffer(bufferSize, false);
    }

    private void fillBuffer(long amount) {
        this.fillBuffer(amount, false);
    }

    private void fillBuffer(long amount, boolean reload) {
        try {
            if (amount > (long)bufferSize) {
                amount = bufferSize;
            }
            log.debug("Buffering amount: {} buffer size: {}", (Object)amount, (Object)bufferSize);
            if (this.channelSize - this.channel.position() < amount) {
                amount = this.channelSize - this.channel.position();
            }
            if (this.in == null) {
                switch (bufferType) {
                    case HEAP: {
                        this.in = IoBuffer.allocate((int)bufferSize, (boolean)false);
                        break;
                    }
                    case DIRECT: {
                        this.in = IoBuffer.allocate((int)bufferSize, (boolean)true);
                        break;
                    }
                    default: {
                        this.in = IoBuffer.allocate((int)bufferSize);
                    }
                }
                this.channel.read(this.in.buf());
                this.in.flip();
                this.useLoadBuf = true;
            }
            if (!this.useLoadBuf) {
                return;
            }
            if (reload || (long)this.in.remaining() < amount) {
                if (!reload) {
                    this.in.compact();
                } else {
                    this.in.clear();
                }
                this.channel.read(this.in.buf());
                this.in.flip();
            }
        }
        catch (Exception e) {
            log.error("Error fillBuffer", (Throwable)e);
        }
    }

    private void postInitialize() {
        if (log.isDebugEnabled()) {
            log.debug("FLVReader 1 - Buffer size: {} position: {} remaining: {}", new Object[]{this.getTotalBytes(), this.getCurrentPosition(), this.getRemainingBytes()});
        }
        if (this.getRemainingBytes() >= 9L) {
            this.decodeHeader();
        }
        if (this.file != null) {
            this.keyframeMeta = this.analyzeKeyFrames();
        }
        long old = this.getCurrentPosition();
        log.debug("Position: {}", (Object)old);
    }

    @Override
    public boolean hasVideo() {
        IKeyFrameDataAnalyzer.KeyFrameMeta meta = this.analyzeKeyFrames();
        if (meta == null) {
            return false;
        }
        return !meta.audioOnly && meta.positions.length > 0;
    }

    public static String getBufferType() {
        switch (bufferType) {
            case AUTO: {
                return "auto";
            }
            case DIRECT: {
                return "direct";
            }
            case HEAP: {
                return "heap";
            }
        }
        return null;
    }

    public static void setBufferType(String bufferType) {
        int bufferTypeHash = bufferType.hashCode();
        switch (bufferTypeHash) {
            case 3198444: {
                FLVReader.bufferType = BufferType.HEAP;
                break;
            }
            case -1331586071: {
                FLVReader.bufferType = BufferType.DIRECT;
                break;
            }
            default: {
                FLVReader.bufferType = BufferType.AUTO;
            }
        }
    }

    public static int getBufferSize() {
        return bufferSize;
    }

    public static void setBufferSize(int bufferSize) {
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        FLVReader.bufferSize = bufferSize;
    }

    public IoBuffer getFileData() {
        return null;
    }

    @Override
    public void decodeHeader() {
        this.fillBuffer(9L);
        this.header = new FLVHeader();
        this.in.skip(4);
        this.header.setTypeFlags(this.in.get());
        this.header.setDataOffset(this.in.getInt());
        if (log.isDebugEnabled()) {
            log.debug("Header: {}", (Object)this.header.toString());
        }
    }

    @Override
    public IStreamableFile getFile() {
        return null;
    }

    @Override
    public int getOffset() {
        return 0;
    }

    @Override
    public long getBytesRead() {
        return this.getCurrentPosition();
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    public int getVideoCodecId() {
        if (this.keyframeMeta != null) {
            return this.keyframeMeta.videoCodecId;
        }
        return -1;
    }

    public int getAudioCodecId() {
        if (this.keyframeMeta != null) {
            return this.keyframeMeta.audioCodecId;
        }
        return -1;
    }

    @Override
    public boolean hasMoreTags() {
        try {
            this.lock.lockInterruptibly();
            boolean bl = this.getRemainingBytes() > 4L;
            return bl;
        }
        catch (InterruptedException e) {
            log.warn("Exception acquiring lock", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.lock.isLocked()) {
                this.lock.unlock();
            }
        }
    }

    private ITag createFileMeta() {
        int codecId;
        long old;
        IoBuffer buf = IoBuffer.allocate((int)192);
        buf.setAutoExpand(true);
        Output out = new Output(buf);
        out.writeString("onMetaData");
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        props.put("duration", (double)this.duration / 1000.0);
        if (this.firstVideoTag != -1L) {
            old = this.getCurrentPosition();
            this.setCurrentPosition(this.firstVideoTag);
            try {
                this.readTagHeader();
                this.fillBuffer(1L);
                codecId = this.in.get() & 0xF;
                props.put("videocodecid", codecId);
            }
            catch (UnsupportedDataTypeException e) {
                log.warn("createFileMeta for video", (Throwable)e);
            }
            this.setCurrentPosition(old);
        }
        if (this.firstAudioTag != -1L) {
            old = this.getCurrentPosition();
            this.setCurrentPosition(this.firstAudioTag);
            try {
                this.readTagHeader();
                this.fillBuffer(1L);
                codecId = (this.in.get() & 0xF0) >> 4;
                props.put("audiocodecid", codecId);
            }
            catch (UnsupportedDataTypeException e) {
                log.warn("createFileMeta for audio", (Throwable)e);
            }
            this.setCurrentPosition(old);
        }
        props.put("canSeekToEnd", true);
        out.writeMap(props);
        buf.flip();
        Tag result = new Tag(18, 0, buf.limit(), null, 0);
        result.setBody(buf);
        out = null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITag readTag() {
        ITag tag = null;
        try {
            this.lock.lockInterruptibly();
            long oldPos = this.getCurrentPosition();
            tag = this.readTagHeader();
            if (tag != null) {
                boolean isMetaData = tag.getDataType() == 18;
                log.debug("readTag, oldPos: {}, tag header: \n{}", (Object)oldPos, (Object)tag);
                if (!this.metadataSent && !isMetaData && this.generateMetadata) {
                    this.setCurrentPosition(oldPos);
                    IKeyFrameDataAnalyzer.KeyFrameMeta meta = this.analyzeKeyFrames();
                    if (meta != null) {
                        this.metadataSent = true;
                        ITag iTag = this.createFileMeta();
                        return iTag;
                    }
                }
                int bodySize = tag.getBodySize();
                IoBuffer body = IoBuffer.allocate((int)bodySize, (boolean)false);
                long newPosition = this.getCurrentPosition() + (long)bodySize;
                if (newPosition <= this.getTotalBytes()) {
                    while (this.getCurrentPosition() < newPosition) {
                        this.fillBuffer(newPosition - this.getCurrentPosition());
                        if (this.getCurrentPosition() + (long)this.in.remaining() > newPosition) {
                            int limit = this.in.limit();
                            this.in.limit((int)(newPosition - this.getCurrentPosition()) + this.in.position());
                            body.put(this.in);
                            this.in.limit(limit);
                            continue;
                        }
                        body.put(this.in);
                    }
                    body.flip();
                    tag.setBody(body);
                }
                if (body.array().length > 0) {
                    int firstByte = body.array()[0] & 0xFF;
                    if ((firstByte & 0xF0) >> 4 == AudioCodec.AAC.getId()) {
                        if (body.array()[1] != 0 && !this.audioConfigRead.get()) {
                            log.debug("Skipping AAC since config has not beean read yet");
                            body.clear();
                            body.free();
                            tag = null;
                        } else if (body.array()[1] == 0 && this.audioConfigRead.compareAndSet(false, true)) {
                            log.debug("AAC config read");
                        }
                    } else if ((firstByte & 0xF) == VideoCodec.AVC.getId()) {
                        if (body.array()[1] != 0 && !this.videoConfigRead.get()) {
                            log.debug("Skipping AVC since config has not beean read yet");
                            body.clear();
                            body.free();
                            tag = null;
                        } else if (body.array()[1] == 0 && this.videoConfigRead.compareAndSet(false, true)) {
                            log.debug("AVC config read");
                        }
                    } else if ((firstByte & 0xF) == VideoCodec.HEVC.getId()) {
                        if (body.array()[1] != 0 && !this.videoConfigRead.get()) {
                            log.debug("Skipping HEVC since config has not beean read yet");
                            body.clear();
                            body.free();
                            tag = null;
                        } else if (body.array()[1] == 0 && this.videoConfigRead.compareAndSet(false, true)) {
                            log.debug("HEVC config read");
                        }
                    } else {
                        log.trace("Media without configuration read");
                    }
                } else {
                    log.debug("Tag body was empty");
                }
            } else {
                log.debug("Tag was null");
            }
        }
        catch (UnsupportedDataTypeException e) {
            log.warn("readTag", (Throwable)e);
            this.close();
        }
        catch (InterruptedException e) {
            log.warn("Exception acquiring lock", (Throwable)e);
        }
        finally {
            if (this.lock.isLocked()) {
                this.lock.unlock();
            }
        }
        return tag;
    }

    @Override
    public void close() {
        log.debug("Reader close: {}", (Object)this.file.getName());
        try {
            this.lock.lock();
            if (this.in != null) {
                this.in.free();
                this.in = null;
            }
            if (this.channel != null) {
                try {
                    this.channel.close();
                    this.fis.close();
                }
                catch (IOException e) {
                    log.error("FLVReader close", (Throwable)e);
                }
            }
            log.debug("Reader closed: {}", (Object)this.file.getName());
        }
        finally {
            if (this.lock.isLocked()) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IKeyFrameDataAnalyzer.KeyFrameMeta analyzeKeyFrames() {
        if (this.keyframeMeta != null) {
            return this.keyframeMeta;
        }
        try {
            this.lock.lockInterruptibly();
            if (keyframeCache != null) {
                this.keyframeMeta = keyframeCache.loadKeyFrameMeta(this.file);
                if (this.keyframeMeta != null) {
                    this.duration = this.keyframeMeta.duration;
                    this.posTimeMap = new HashMap();
                    for (int i = 0; i < this.keyframeMeta.positions.length; ++i) {
                        this.posTimeMap.put(this.keyframeMeta.positions[i], Long.valueOf(this.keyframeMeta.timestamps[i]));
                    }
                    IKeyFrameDataAnalyzer.KeyFrameMeta i = this.keyframeMeta;
                    return i;
                }
            }
            this.keyframeMeta = new IKeyFrameDataAnalyzer.KeyFrameMeta();
            ArrayList<Long> positionList = new ArrayList<Long>();
            ArrayList<Integer> timestampList = new ArrayList<Integer>();
            ArrayList<Long> audioPositionList = new ArrayList<Long>();
            ArrayList<Integer> audioTimestampList = new ArrayList<Integer>();
            long origPos = this.getCurrentPosition();
            this.setCurrentPosition(9L);
            int totalValidTags = 0;
            boolean audioOnly = true;
            while (this.hasMoreTags()) {
                long pos = this.getCurrentPosition();
                ITag tmpTag = null;
                try {
                    tmpTag = this.readTagHeader();
                }
                catch (UnsupportedDataTypeException e) {
                    log.warn("analyzeKeyFrames", (Throwable)e);
                }
                if (tmpTag == null) break;
                ++totalValidTags;
                this.duration = tmpTag.getTimestamp();
                if (tmpTag.getDataType() == 9) {
                    if (audioOnly) {
                        audioOnly = false;
                        audioPositionList.clear();
                        audioTimestampList.clear();
                    }
                    if (this.firstVideoTag == -1L) {
                        this.firstVideoTag = pos;
                    }
                    this.fillBuffer(1L);
                    byte frametype = this.in.get();
                    if (this.keyframeMeta.videoCodecId == -1) {
                        this.keyframeMeta.videoCodecId = frametype & 0xF;
                    }
                    if ((frametype & 0xF0) >> 4 == 1) {
                        positionList.add(pos);
                        timestampList.add(tmpTag.getTimestamp());
                    }
                } else if (tmpTag.getDataType() == 8) {
                    if (this.firstAudioTag == -1L) {
                        this.firstAudioTag = pos;
                    }
                    this.fillBuffer(1L);
                    int frametype = this.in.get() & 0xFF;
                    if (this.keyframeMeta.audioCodecId == -1) {
                        this.keyframeMeta.audioCodecId = (frametype & 0xF0) >> 4;
                    }
                    if (audioOnly) {
                        audioPositionList.add(pos);
                        audioTimestampList.add(tmpTag.getTimestamp());
                    }
                }
                long newPosition = pos + (long)tmpTag.getBodySize() + 15L;
                if (newPosition >= this.getTotalBytes()) {
                    log.error("New position exceeds limit");
                    if (log.isDebugEnabled()) {
                        log.debug("-----\nKeyframe analysis\n\tdata type={} bodysize={}\n\tremaining={} limit={}\n\tnew pos={} pos={}\n-----", new Object[]{tmpTag.getDataType(), tmpTag.getBodySize(), this.getRemainingBytes(), this.getTotalBytes(), newPosition, pos});
                    }
                    log.info("New position {} exceeds limit {}", (Object)newPosition, (Object)this.getTotalBytes());
                    break;
                }
                this.setCurrentPosition(newPosition);
            }
            this.setCurrentPosition(origPos);
            log.debug("Total valid tags found: {}", (Object)totalValidTags);
            this.keyframeMeta.duration = this.duration;
            this.posTimeMap = new HashMap();
            if (audioOnly) {
                positionList = audioPositionList;
                timestampList = audioTimestampList;
            }
            this.keyframeMeta.audioOnly = audioOnly;
            this.keyframeMeta.positions = new long[positionList.size()];
            this.keyframeMeta.timestamps = new int[timestampList.size()];
            for (int i = 0; i < this.keyframeMeta.positions.length; ++i) {
                this.keyframeMeta.positions[i] = (Long)positionList.get(i);
                this.keyframeMeta.timestamps[i] = (Integer)timestampList.get(i);
                this.posTimeMap.put((long)((Long)positionList.get(i)), (long)((Integer)timestampList.get(i)));
            }
            if (keyframeCache != null) {
                keyframeCache.saveKeyFrameMeta(this.file, this.keyframeMeta);
            }
        }
        catch (InterruptedException e) {
            log.warn("Exception acquiring lock", (Throwable)e);
        }
        finally {
            if (this.lock.isLocked()) {
                this.lock.unlock();
            }
        }
        return this.keyframeMeta;
    }

    @Override
    public void position(long pos) {
        this.setCurrentPosition(pos);
    }

    private ITag readTagHeader() throws UnsupportedDataTypeException {
        this.fillBuffer(15L);
        int previousTagSize = this.in.getInt();
        byte dataType = this.in.get();
        if (log.isTraceEnabled()) {
            log.trace("Bits: {}", (Object)Integer.toBinaryString(dataType));
        }
        dataType = (byte)(dataType & 0x1F);
        byte filter = (byte)((dataType & 0x3F) >> 5);
        byte reserved = (byte)((dataType & 0x7F) >> 6);
        log.debug("Reserved: {}, Filter: {}, Datatype: {}", new Object[]{reserved, filter, dataType});
        switch (dataType) {
            case 8: {
                log.debug("Found audio");
                break;
            }
            case 9: {
                log.debug("Found video");
                break;
            }
            case 15: 
            case 18: {
                log.debug("Found meta/script data");
                break;
            }
            default: {
                log.debug("Invalid data type detected ({}), reading ahead\n current position: {} limit: {}", new Object[]{dataType, this.in.position(), this.in.limit()});
                throw new UnsupportedDataTypeException("Invalid data type detected (" + dataType + ")");
            }
        }
        int bodySize = IOUtils.readUnsignedMediumInt(this.in);
        int timestamp = IOUtils.readExtendedMediumInt(this.in);
        int streamId = IOUtils.readUnsignedMediumInt(this.in);
        if (log.isDebugEnabled()) {
            log.debug("Data type: {} timestamp: {} stream id: {} body size: {} previous tag size: {}", new Object[]{dataType, timestamp, streamId, bodySize, previousTagSize});
        }
        return new Tag(dataType, timestamp, bodySize, null, previousTagSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDuration(File flvFile) {
        int duration = 0;
        RandomAccessFile flv = null;
        try {
            flv = new RandomAccessFile(flvFile, "r");
            long flvLength = Math.max(flvFile.length(), flv.length());
            log.debug("File length: {}", (Object)flvLength);
            if (flvLength > 13L) {
                flv.seek(flvLength - 4L);
                int lastTagSize = flv.readInt();
                log.debug("Last tag size: {}", (Object)lastTagSize);
                if (lastTagSize > 0 && (long)lastTagSize < flvLength) {
                    flv.seek(flvLength - (long)lastTagSize);
                    duration = flv.readInt();
                    duration = duration >>> 8 | (duration & 0xFF) << 24;
                } else {
                    flv.seek(13L);
                    byte tagType = flv.readByte();
                    if (tagType == 18) {
                        ByteBuffer buf = ByteBuffer.allocate(3);
                        flv.getChannel().read(buf);
                        int bodySize = IOUtils.readMediumInt(buf);
                        log.debug("Metadata body size: {}", (Object)bodySize);
                        flv.skipBytes(4);
                        flv.skipBytes(3);
                        buf.clear();
                        buf = ByteBuffer.allocate(bodySize);
                        flv.getChannel().read(buf);
                        IoBuffer ioBuf = IoBuffer.wrap((ByteBuffer)buf);
                        Input input = new Input(ioBuf);
                        String metaType = (String)Deserializer.deserialize(input, String.class);
                        log.debug("Metadata type: {}", (Object)metaType);
                        Map meta = (Map)Deserializer.deserialize(input, Map.class);
                        Object tmp = meta.get("duration");
                        if (tmp != null) {
                            duration = tmp instanceof Double ? ((Double)tmp).intValue() : Integer.valueOf((String)tmp).intValue();
                        }
                        input = null;
                        meta.clear();
                        meta = null;
                        ioBuf.clear();
                        ioBuf.free();
                        ioBuf = null;
                    }
                }
            }
        }
        catch (IOException e) {
            log.warn("Exception getting file duration", (Throwable)e);
        }
        finally {
            try {
                if (flv != null) {
                    flv.close();
                }
            }
            catch (IOException iOException) {}
            flv = null;
        }
        return duration;
    }

    final class UnsupportedDataTypeException
    extends IOException {
        private static final long serialVersionUID = 4892905470375245996L;

        UnsupportedDataTypeException(String message) {
            super(message);
        }
    }
}

