/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.matroska.dtd;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.red5.io.matroska.ParserUtils;
import org.red5.io.matroska.VINT;
import org.red5.io.matroska.dtd.Tag;

public class StringTag
extends Tag {
    private String value = "";

    public StringTag(String name, VINT id) throws IOException {
        super(name, id);
    }

    public StringTag(String name, VINT id, VINT size, InputStream inputStream) throws IOException {
        super(name, id, size, inputStream);
    }

    @Override
    public void parse(InputStream inputStream) throws IOException {
        this.value = ParserUtils.parseString(inputStream, (int)this.getSize());
    }

    @Override
    protected void putValue(ByteBuffer bb) throws IOException {
        bb.put(this.value.getBytes("UTF-8"));
    }

    public String getValue() {
        return this.value;
    }

    public StringTag setValue(String value) throws UnsupportedEncodingException {
        if (value != null) {
            this.value = value;
        }
        byte[] bb = this.value.getBytes("UTF-8");
        this.size = VINT.fromValue(bb.length);
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + " = " + this.value;
    }
}

