/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.sctp.packet;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.red5.io.sctp.IAssociationControl;
import org.red5.io.sctp.IServerChannelControl;
import org.red5.io.sctp.SctpException;
import org.red5.io.sctp.packet.SctpHeader;
import org.red5.io.sctp.packet.chunks.Chunk;
import org.red5.io.sctp.packet.chunks.ChunkFactory;

public class SctpPacket {
    private SctpHeader header;
    private ArrayList<Chunk> chunks = new ArrayList();

    public SctpPacket(byte[] data, int offset, int length) throws SctpException {
        this.header = new SctpHeader(data, offset, length);
        Chunk chunk = null;
        length -= this.header.getSize();
        int i = this.header.getSize() + offset;
        while (length != 0) {
            chunk = ChunkFactory.createChunk(data, i, length);
            this.chunks.add(chunk);
            length -= chunk.getSize();
            i += chunk.getSize();
        }
    }

    public SctpPacket(int sourcePort, int destinationPort, int verificationTag, Chunk chunk) {
        this.header = new SctpHeader(sourcePort, destinationPort, verificationTag, 0);
        this.chunks.add(chunk);
    }

    public void apply(InetSocketAddress address, IServerChannelControl server) throws SctpException, IOException, InvalidKeyException, NoSuchAlgorithmException {
        for (Chunk chunk : this.chunks) {
            chunk.apply(address, server);
        }
    }

    public void apply(IAssociationControl association) throws SctpException, IOException, InvalidKeyException, NoSuchAlgorithmException {
        for (Chunk chunk : this.chunks) {
            chunk.apply(association);
        }
    }

    public byte[] getBytes() {
        int resultSize = this.header.getSize();
        for (Chunk chunk : this.chunks) {
            resultSize += chunk.getSize();
        }
        byte[] result = new byte[resultSize];
        System.arraycopy(this.header.getBytes(), 0, result, 0, this.header.getSize());
        int previousChunkSize = this.header.getSize();
        for (Chunk chunk : this.chunks) {
            System.arraycopy(chunk.getBytes(), 0, result, previousChunkSize, chunk.getSize());
            previousChunkSize += chunk.getSize();
        }
        return result;
    }

    public int getSourcePort() {
        return this.header.getSourcePort();
    }

    public int getVerificationTag() {
        return this.header.getVerificationTag();
    }
}

