/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.sctp.packet.chunks;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import org.red5.io.sctp.IAssociationControl;
import org.red5.io.sctp.IServerChannelControl;
import org.red5.io.sctp.SctpException;
import org.red5.io.sctp.packet.SctpPacket;
import org.red5.io.sctp.packet.chunks.Chunk;
import org.red5.io.sctp.packet.chunks.ChunkType;
import org.red5.io.sctp.packet.chunks.CookieEcho;
import org.red5.io.sctp.packet.chunks.StateCookie;

public final class InitAck
extends Chunk {
    private static final int MANDATORY_FIELD_SIZE = 16;
    private int initiateTag;
    private int advertisedReceiverWindowCredit;
    private int numberOfOutboundStreams;
    private int numberOfInboundStreams;
    private int initialTSN;
    StateCookie stateCookie;
    byte[] stateCookieBytes;

    public InitAck(byte[] data, int offset, int length) throws SctpException {
        super(data, offset, length);
        assert (length - offset - 4 > 16);
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, offset + 4, 16);
        this.initiateTag = byteBuffer.getInt();
        this.advertisedReceiverWindowCredit = byteBuffer.getInt();
        this.numberOfOutboundStreams = byteBuffer.getShort() & 0xFFFF;
        this.numberOfInboundStreams = byteBuffer.getShort() & 0xFFFF;
        this.initialTSN = byteBuffer.getInt();
        this.stateCookie = new StateCookie(data, offset + 16 + 4, length - 20);
    }

    public InitAck(int initiateTag, int initialTSN, StateCookie stateCookie, Mac mac) throws InvalidKeyException, NoSuchAlgorithmException {
        super(ChunkType.INIT_ACK, (byte)0);
        this.initiateTag = initiateTag;
        this.initialTSN = initialTSN;
        this.stateCookie = stateCookie;
        this.stateCookieBytes = stateCookie.getBytes(mac);
        this.numberOfInboundStreams = 1;
        this.numberOfOutboundStreams = 1;
        this.advertisedReceiverWindowCredit = 1024;
        super.setLength(16 + this.stateCookieBytes.length + super.getSize());
    }

    @Override
    public byte[] getBytes() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(16 + super.getSize() + this.stateCookieBytes.length);
        byte[] data = super.getBytes();
        byteBuffer.put(data);
        byteBuffer.putInt(this.initiateTag);
        byteBuffer.putInt(this.advertisedReceiverWindowCredit);
        byteBuffer.putShort((short)this.numberOfOutboundStreams);
        byteBuffer.putShort((short)this.numberOfInboundStreams);
        byteBuffer.putInt(this.initialTSN);
        byteBuffer.put(this.stateCookieBytes);
        byteBuffer.clear();
        byte[] result = new byte[byteBuffer.capacity()];
        byteBuffer.get(result, 0, result.length);
        return result;
    }

    @Override
    public int getSize() {
        return 16 + this.stateCookie.getSize() + super.getSize();
    }

    @Override
    public void apply(IAssociationControl channel) throws IOException, InvalidKeyException, NoSuchAlgorithmException, SctpException {
        if (channel.getState() != IAssociationControl.State.COOKIE_WAIT) {
            throw new SctpException("init ack chunk : wrong state " + channel.getState());
        }
        CookieEcho cookieEcho = new CookieEcho(this.stateCookie.getBytes(null));
        SctpPacket packet = new SctpPacket((short)channel.getSourcePort(), (short)channel.getDestinationPort(), 0, cookieEcho);
        channel.sendPacket(packet);
        channel.setState(IAssociationControl.State.COOKIE_ECHOED);
    }

    @Override
    public void apply(InetSocketAddress address, IServerChannelControl server) throws SctpException {
        throw new SctpException("init ack chunk : not using with server");
    }

    public int getInitiateTag() {
        return this.initiateTag;
    }

    public int getAdvertisedReceiverWindowCredit() {
        return this.advertisedReceiverWindowCredit;
    }

    public int getNumberOfOutboundStreams() {
        return this.numberOfOutboundStreams;
    }

    public int getNumberOfInboundStreams() {
        return this.numberOfInboundStreams;
    }

    public int getInitialTSN() {
        return this.initialTSN;
    }
}

