/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.utils;

import java.nio.ByteBuffer;
import java.util.UUID;

public class RandomGUID {
    private static final String hexChars = "0123456789ABCDEF";

    private RandomGUID() {
    }

    public static final byte[] toByteArray(String uid) {
        byte[] result = new byte[16];
        char[] chars = uid.toCharArray();
        int r = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '-') continue;
            int h1 = Character.digit(chars[i], 16);
            int h2 = Character.digit(chars[++i], 16);
            result[r++] = (byte)((h1 << 4 | h2) & 0xFF);
        }
        return result;
    }

    public static String fromByteArray(byte[] ba) {
        if (ba != null && ba.length == 16) {
            StringBuilder result = new StringBuilder(36);
            for (int i = 0; i < 16; ++i) {
                if (i == 4 || i == 6 || i == 8 || i == 10) {
                    result.append('-');
                }
                result.append(hexChars.charAt((ba[i] & 0xF0) >>> 4));
                result.append(hexChars.charAt(ba[i] & 0xF));
            }
            return result.toString();
        }
        return null;
    }

    public static String getPrettyFormatted(String str) {
        return String.format("%s-%s-%s-%s-%s", str.substring(0, 8), str.substring(8, 12), str.substring(12, 16), str.substring(16, 20), str.substring(20));
    }

    public static String create() {
        UUID id = UUID.randomUUID();
        byte[] bytes = ByteBuffer.allocate(16).putLong(id.getLeastSignificantBits()).putLong(id.getMostSignificantBits()).array();
        return RandomGUID.fromByteArray(bytes);
    }
}

