/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.message;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.message.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Packet
implements Externalizable {
    private static final long serialVersionUID = -6415050845346626950L;
    private static Logger log = LoggerFactory.getLogger(Packet.class);
    private static final boolean noCopy = System.getProperty("packet.noCopy") == null ? false : Boolean.valueOf(System.getProperty("packet.noCopy"));
    private Header header;
    private IRTMPEvent message;
    private IoBuffer data;
    private transient long expirationTime = 0L;
    private final transient AtomicBoolean processed = new AtomicBoolean(false);

    public Packet() {
        log.trace("ctor");
    }

    public Packet(Header header) {
        if (log.isTraceEnabled()) {
            log.trace("Header: {}", (Object)header);
        }
        this.header = header;
        this.data = IoBuffer.allocate((int)header.getSize()).setAutoExpand(true);
    }

    public Packet(Header header, IRTMPEvent event) {
        if (log.isTraceEnabled()) {
            log.trace("Header: {} event: {}", (Object)header, (Object)event);
        }
        this.header = header;
        this.message = event;
    }

    public Header getHeader() {
        return this.header;
    }

    public void setMessage(IRTMPEvent message) {
        this.message = message;
    }

    public IRTMPEvent getMessage() {
        return this.message;
    }

    public void setData(IoBuffer buffer) {
        if (noCopy) {
            log.trace("Using buffer reference");
            this.data = buffer;
        } else if (buffer.hasArray()) {
            log.trace("Buffer has backing array, making a copy");
            byte[] copy = new byte[buffer.limit()];
            buffer.mark();
            buffer.get(copy);
            buffer.reset();
            this.data = IoBuffer.wrap((byte[])copy);
        } else {
            log.trace("Buffer has no backing array, using ByteBuffer");
            this.data.put(buffer.buf()).flip();
        }
    }

    public IoBuffer getData() {
        return this.data;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public void clearData() {
        if (this.data != null) {
            this.data.clear();
            this.data.free();
            this.data = null;
        }
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public boolean isExpired() {
        return this.expirationTime > 0L ? System.currentTimeMillis() > this.expirationTime : false;
    }

    public void setProcessed(boolean isProcessed) {
        this.processed.set(isProcessed);
    }

    public boolean isProcessed() {
        return this.processed.get();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.header = (Header)in.readObject();
        this.message = (IRTMPEvent)in.readObject();
        this.message.setHeader(this.header);
        this.message.setTimestamp(this.header.getTimer());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.header);
        out.writeObject(this.message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Packet [");
        if (this.header != null) {
            sb.append("[");
            sb.append(this.header.toString());
            sb.append("]");
        } else {
            sb.append("[Header=null]");
        }
        if (this.message != null) {
            sb.append(", [Message timestamp=" + this.message.getTimestamp() + "]");
        } else {
            sb.append(", [Message=null]");
        }
        sb.append("]");
        return sb.toString();
    }
}

