/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.VideoData;
import org.red5.server.stream.IFrameDropper;
import org.red5.server.stream.message.RTMPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoFrameDropper
implements IFrameDropper {
    protected static Logger log = LoggerFactory.getLogger((String)VideoFrameDropper.class.getName());
    private int state;

    public VideoFrameDropper() {
        this.reset();
    }

    @Override
    public void reset() {
        this.reset(0);
    }

    @Override
    public void reset(int state) {
        this.state = state;
    }

    @Override
    public boolean canSendPacket(RTMPMessage message, long pending) {
        IRTMPEvent packet = message.getBody();
        boolean result = true;
        if (packet instanceof VideoData) {
            VideoData video = (VideoData)packet;
            VideoData.FrameType type = video.getFrameType();
            switch (this.state) {
                case 0: {
                    break;
                }
                case 1: {
                    if (type == VideoData.FrameType.KEYFRAME) {
                        if (pending != 0L) break;
                        this.state = 0;
                        break;
                    }
                    if (type != VideoData.FrameType.INTERFRAME) break;
                    break;
                }
                case 2: {
                    boolean bl = result = type == VideoData.FrameType.KEYFRAME;
                    if (!result || pending != 0L) break;
                    this.state = 3;
                    break;
                }
                case 3: {
                    boolean bl = result = type == VideoData.FrameType.KEYFRAME;
                    if (!result || pending != 0L) break;
                    this.state = 1;
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public void dropPacket(RTMPMessage message) {
        IRTMPEvent packet = message.getBody();
        if (packet instanceof VideoData) {
            VideoData video = (VideoData)packet;
            VideoData.FrameType type = video.getFrameType();
            switch (this.state) {
                case 0: {
                    if (type == VideoData.FrameType.DISPOSABLE_INTERFRAME) {
                        return;
                    }
                    if (type == VideoData.FrameType.INTERFRAME) {
                        this.state = 2;
                        return;
                    }
                    if (type != VideoData.FrameType.KEYFRAME) break;
                    this.state = 2;
                    return;
                }
                case 1: {
                    if (type == VideoData.FrameType.INTERFRAME) {
                        this.state = 3;
                        return;
                    }
                    if (type != VideoData.FrameType.KEYFRAME) break;
                    this.state = 2;
                    return;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (type != VideoData.FrameType.KEYFRAME) break;
                    this.state = 2;
                    return;
                }
            }
        }
    }

    @Override
    public void sendPacket(RTMPMessage message) {
    }
}

